(* unix-signals.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * This extends the generic SIGNALS interface to POSIX signals.
 *)

structure UnixSignals : UNIX_SIGNALS =
  struct
    open Signals

  (** The following signals are already defined in SIGNALS:
   **
   **  val sigHUP  : signal	(* hangup *)
   **  val sigINT  : signal	(* interactive interrupt *)
   **  val sigALRM : signal	(* interval timer signal *)
   **  val sigTERM : signal	(* termination *)
   **  val sigGC   : signal	(* garbage collection *)
   **)

  (* required Posix signals *)
    val sigPIPE : signal = valOf(fromString "PIPE")
    val sigQUIT : signal = valOf(fromString "QUIT")
    val sigUSR1 : signal = valOf(fromString "USR1")
    val sigUSR2 : signal = valOf(fromString "USR2")

  (* job-control signals *)
    val sigCHLD : signal = valOf(fromString "CHLD")
    val sigCONT : signal = valOf(fromString "CONT")
    val sigTSTP : signal = valOf(fromString "TSTP")
    val sigTTIN : signal = valOf(fromString "TTIN")
    val sigTTOU : signal = valOf(fromString "TTOU")

  (** other UNIX signals that may be available (depending on the OS):
   **
   ** val sigWINCH  : signal
   ** val sigURG    : signal
   ** val sigIO     : signal
   ** val sigPOLL   : signal
   ** val sigVTALRM : signal
   **)

   end (* UnixSignals *)

