(* unix-sock.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

structure UnixSock : UNIX_SOCK =
  struct
    structure AF = Sock.AF
    structure SOCK = Sock.SOCK

    val sockFn = CInterface.c_function "SMLNJ-Sockets"

    datatype unix = UNIX

(** We should probably do some error checking on the length of the string *)
    local
      val mkUnixAddr = sockFn "mkUnixAddr"
    in
    fun addr s = PreSock.ADDR(mkUnixAddr s)
    end

    structure Strm =
      struct
	fun socket () = GenericSock.socket (AF.unix, SOCK.stream)
	fun socket' proto = GenericSock.socket' (AF.unix, SOCK.stream, proto)
	fun socketPair () = GenericSock.socketPair (AF.unix, SOCK.stream)
	fun socketPair' proto = GenericSock.socketPair' (AF.unix, SOCK.stream, proto)
      end
    structure DGrm =
      struct
	fun socket () = GenericSock.socket (AF.unix, SOCK.dgram)
	fun socket' proto = GenericSock.socket' (AF.unix, SOCK.dgram, proto)
	fun socketPair () = GenericSock.socketPair (AF.unix, SOCK.dgram)
	fun socketPair' proto = GenericSock.socketPair' (AF.unix, SOCK.dgram, proto)
      end
  end;

