(* unix-sock-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature UNIX_SOCK =
  sig
    type unix

    val addr : string -> unix Sock.sock_addr

    structure Strm : sig
	val socket     : unit -> (unix, 'a Sock.stream) Sock.sock
	val socketPair : unit
	      -> ((unix, 'a Sock.stream) Sock.sock * (unix, 'a Sock.stream) Sock.sock)
      end
    structure DGrm : sig
	val socket     : unit -> (unix, Sock.dgram) Sock.sock
	val socketPair : unit
	      -> ((unix, Sock.dgram) Sock.sock * (unix, Sock.dgram) Sock.sock)
      end
  end;
