(* ip-sock.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

structure IPSock : IP_SOCK =
  struct
    structure AF = Sock.AF
    structure SOCK = Sock.SOCK

    val sockFn = CInterface.c_function "SMLNJ-Sockets"

    datatype ip = IP

    val mkInetAddr : (PreSock.addr * int) -> PreSock.addr = sockFn "mkinetaddr"
    val inetAny  : int -> PreSock.addr = sockFn "inetany"

    fun addr (PreSock.INADDR a, port) = PreSock.ADDR(mkInetAddr(a, port))
    fun any port = PreSock.ADDR(inetAny port)

    structure UDP =
      struct
	fun socket () = GenericSock.socket (AF.inet, SOCK.dgram)
	fun socket' proto = GenericSock.socket' (AF.inet, SOCK.dgram, proto)
      end

    structure TCP =
      struct
	fun socket () = GenericSock.socket (AF.inet, SOCK.stream)
	fun socket' proto = GenericSock.socket' (AF.inet, SOCK.stream, proto)
      (* tcp control options *)
	local
	  val ctlDELAY : (int * bool option) -> bool = sockFn "ctlNODELAY"
	in
	fun getNODELAY (PreSock.SOCK fd) = ctlDELAY(fd, NONE)
	fun setNODELAY (PreSock.SOCK fd, flg) = ignore(ctlDELAY(fd, SOME flg))
	end (* local *)
      end
  end
