(* ip-sock-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature IP_SOCK =
  sig

    type ip

    val addr : (NetHostDB.in_addr * int) -> ip Sock.sock_addr
    val any  : int -> ip Sock.sock_addr

    structure UDP : sig
	val socket  : unit -> (ip, Sock.dgram) Sock.sock
	val socket' : int -> (ip, Sock.dgram) Sock.sock
      end

    structure TCP : sig
	val socket  : unit -> (ip, 'a Sock.stream) Sock.sock
	val socket' : int -> (ip, 'a Sock.stream) Sock.sock
      (* tcp control options *)
	val getNODELAY : (ip, 'a Sock.stream) Sock.sock -> bool
	val setNODELAY : ((ip, 'a Sock.stream) Sock.sock * bool) -> unit
      end
  end
