(* host-db-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature NET_HOST_DB =
  sig
    eqtype in_addr
    eqtype addr_family
    type entry
    val name     : entry -> string
    val aliases  : entry -> string list
    val addrType : entry -> addr_family
    val addrs    : entry -> in_addr list
    val getByName    : string -> entry option
    val getByAddr    : in_addr -> entry option
    val stringToInetAddr : string -> in_addr option
    val inetAddrToString : in_addr -> string
    val getHostName : unit -> string
  end
