(* generic-sock-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature GENERIC_SOCK =
  sig
    val addressFamilies : unit -> Sock.addr_family list
	(* returns a list of the supported address families; this should include
	 * at least:  Socket.AF.inet.
	 *)

    val socketTypes : unit -> Sock.sock_type
	(* returns a list of the supported socket types; this should include at
	 * least:  Socket.SOCK.stream and Socket.SOCK.dgram.
	 *)

  (* create sockets using default protocol *)
    val socket : (Sock.addr_family * Sock.sock_type)
	  -> ('a, 'b) Sock.sock
    val socketPair : (Sock.addr_family * Sock.sock_type)
	  -> (('a, 'b) Sock.sock * ('a, 'b) Sock.sock)

  (* create sockets using the specified protocol *)
    val socket' : (Sock.addr_family * Sock.sock_type * int)
	  -> ('a, 'b) Sock.sock
    val socketPair' : (Sock.addr_family * Sock.sock_type * int)
	  -> (('a, 'b) Sock.sock * ('a, 'b) Sock.sock)

  end
