(* posix-error.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * Structure for POSIX error codes.
 *)

structure POSIX_Error =
  struct

    type syserror = int (* = PreBasis.syserror *)

    val cfun = CInterface.c_function "POSIX-Error"
    val osval : string -> int = cfun "osval"

    val errmsg' : int -> string = cfun "errmsg"
    fun errorMsg i = errmsg' i
    fun wordOf i = SysWord.fromInt i
    fun syserror w = SysWord.toInt w

    val toobig      = osval "toobig"
    val acces       = osval "acces"
    val again       = osval "again"
    val badf        = osval "badf"
    val badmsg      = osval "badmsg"
    val busy        = osval "busy"
    val canceled    = osval "canceled"
    val child       = osval "child"
    val deadlk      = osval "deadlk"
    val dom         = osval "dom"
    val exist       = osval "exist"
    val fault       = osval "fault"
    val fbig        = osval "fbig"
    val inprogress  = osval "inprogress"
    val intr        = osval "intr"
    val inval       = osval "inval"
    val io          = osval "io"
    val isdir       = osval "isdir"
    val loop        = osval "loop"
    val mfile       = osval "mfile"
    val mlink       = osval "mlink"
    val msgsize     = osval "msgsize"
    val nametoolong = osval "nametoolong"
    val nfile       = osval "nfile"
    val nodev       = osval "nodev"
    val noent       = osval "noent"
    val noexec      = osval "noexec"
    val nolck       = osval "nolck"
    val nomem       = osval "nomem"
    val nospc       = osval "nospc"
    val nosys       = osval "nosys"
    val notdir      = osval "notdir"
    val notempty    = osval "notempty"
    val notsup      = osval "notsup"
    val notty       = osval "notty"
    val nxio        = osval "nxio"
    val perm        = osval "perm"
    val pipe        = osval "pipe"
    val range       = osval "range"
    val rofs        = osval "rofs"
    val spipe       = osval "spipe"
    val srch        = osval "srch"
    val xdev        = osval "xdev"

  end (* structure POSIX_Error *)
