(* smlnj.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

structure SMLofNJ (* : SML_OF_NJ *) =
  struct

  (* command-line arguments *)
    val getArgs	: unit -> string list
	  = CInterface.c_function "SMLNJ-RunT" "argv"
    val getAllArgs : unit -> string list
	  = CInterface.c_function "SMLNJ-RunT" "rawArgv"

    type 'a cont = 'a cont

    val callcc : ('1a cont -> '1a) -> '1a = InlineT.callcc
    val throw : 'a cont -> 'a -> 'b = InlineT.throw

(** How do we define this here???
    val use = Compiler.Interact.use_file
**)

    datatype 'a frag = QUOTE of string | ANTIQUOTE of 'a

    val exnHistory : exn -> string list =
	   InlineT.cast(fn (_,_,hist: string list) => hist)

  end;

