(* interval-timer.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * An interface to system interval timers.
 *)

structure IntervalTimer : INTERVAL_TIMER =
  struct

    val cfun = CInterface.c_function "SMLNJ-RunT"

    val tick' : unit -> (int * int) = cfun "intervalTick"
    val setITimer : (int * int) option -> unit = cfun "setIntTimer"
    val setPTimer : (int * int) option -> unit = cfun "setProfTimer"

    fun tick () = let val (s, us) = tick'()
	  in
	    PreBasis.TIME{sec=s, usec=us}
	  end

    fun fromTimeOpt NONE = NONE
      | fromTimeOpt (SOME(PreBasis.TIME{sec, usec})) = SOME(sec, usec)

    fun setIntTimer timOpt = setITimer(fromTimeOpt timOpt)
    fun setProfTimer timOpt = setPTimer(fromTimeOpt timOpt)

  end;

