(* textio2-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature TEXT_IO =
  sig
    type instream 
    type outstream
    type elem
    type vector        
    type subvector
    type pos

    val closeIn      : instream -> unit
    val input         : instream -> vector
    val inputAll     : instream -> vector
    val inputNoBlock : instream -> vector option
    val input1        : instream -> elem option
    val inputN       : instream * int -> vector
    val endOfStream : instream -> bool
    val lookahead     : instream -> elem option
    val setPosIn     : instream * pos -> unit
    val getPosIn     : instream -> pos
    val endPosIn     : instream -> pos

    val closeOut : outstream -> unit
    val output    : (outstream * vector) -> unit
    val outputS    : outstream * subvector -> unit
    val output1    : outstream * elem -> unit
    val flushOut : outstream -> unit
    val getPosOut  : outstream -> pos
    val endPosOut  : outstream -> pos
    val setPosOut  : outstream * pos -> unit

     structure StreamIO : 
        sig 
	   structure PrimIO: PRIM_IO

	   type elem   sharing type elem = PrimIO.elem
	   type vector sharing type vector = PrimIO.vector
	   type subvector
	   type pos    sharing type pos = PrimIO.pos

	   type instream
	   type outstream

	   val mkInstream   : PrimIO.reader -> instream
	   val closeIn      : instream -> unit
	   val setPosIn     : instream * pos -> instream
	   val getPosIn     : instream -> pos
	   val endPosIn     : instream -> pos
	   val input         : instream -> vector * instream
	   val inputAll     : instream -> vector
	   val inputNoBlock : instream -> (vector * instream) option
	   val input1        : instream -> elem option * instream
	   val inputN       : instream * int -> vector * instream
	   val endOfStream : instream -> bool
	   val getReader    : instream -> PrimIO.reader

	   val mkOutstream : PrimIO.writer -> outstream
	   val closeOut : outstream -> unit
	   val output    : (outstream * vector) -> unit
	   val outputS   : (outstream * subvector) -> unit
	   val output1   : (outstream * elem) -> unit
	   val flushOut : outstream -> unit
	   val getPosOut  : outstream -> pos
	   val setPosOut  : outstream * pos -> unit
	   val endPosOut  : outstream -> pos
	   val getWriter: outstream -> PrimIO.writer
            val inputLine: instream -> string * instream
        end
      sharing type elem = StreamIO.elem
      sharing type vector = StreamIO.vector
      sharing type subvector = StreamIO.subvector
      sharing type pos = StreamIO.pos

      val mkInstream   : StreamIO.instream -> instream
      val getInstream  : instream -> StreamIO.instream
      val setInstream  : instream * StreamIO.instream -> unit

      val mkOutstream  : StreamIO.outstream -> outstream
      val getOutstream : outstream -> StreamIO.outstream
      val setOutstream : outstream * StreamIO.outstream -> unit

     sharing type pos=Position.int
     val openIn : string -> instream
     val openOut: string -> outstream
     val openAppend: string -> outstream
     val stdIn : instream
     val stdOut: outstream
     val stdErr: outstream
     sharing type StreamIO.elem = char
     sharing type StreamIO.vector = string
     val inputLine : instream -> string
  end
