(* primio.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

functor PrimIO (

    structure A : MONO_ARRAY
    structure V : MONO_VECTOR
      sharing type A.vector=V.vector
      sharing type A.elem=V.elem
    val someElem : A.elem
    type pos
    val posLess: pos*pos->bool

  ) : PRIM_IO = struct

   type elem = A.elem
   type vector = V.vector
   type array = A.array
(*   type iodesc=iodesc*)
   type pos = pos
   val posLess=posLess
   type 'a portion = {data: 'a, first: int, nelems: int}

    datatype reader = Rd of {
	readBlock    : (int -> vector) option,
	readaBlock   : ({data: array, first: int, nelems: int} -> int) option,
	readNoBlock  : (int -> vector option) option,
	readaNoBlock : ({data: array, first: int, nelems: int} -> int option) option,
	block        : (unit -> unit) option,
	canInput     : (unit -> bool) option,
	name         : string,
	chunkSize    : int,
	close        : unit -> unit,
	getPos       : unit -> pos,
	findPos      : {data: vector, first: int, nelems: int}*pos -> pos,
	setPos       : (pos -> unit),
	endPos       : (unit -> pos),
	desc         : OS.IO.io_desc option
      }

    datatype writer = Wr of {
	writeNoBlock  : ({data: vector, first: int, nelems: int} -> int option) option,
	writeaNoBlock : ({data: array, first: int, nelems: int} -> int option) option,
	writeBlock    : ({data: vector, first: int, nelems: int} -> int) option,
	writeaBlock   : ({data: array, first: int, nelems: int} -> int) option,
	block         : (unit->unit) option,
	canOutput     : (unit->bool) option,
	name          : string,
	chunkSize     : int,
	lineBuf       : (elem -> bool) option,
	close         : unit -> unit,
	getPos        : (unit->pos),
	setPos        : (pos->unit),
	endPos        : (unit->pos),
	desc          : OS.IO.io_desc option
      }

    fun noOption convert f x = (case convert f x
           of SOME result => result
	    | NONE => raise Fail "bug in PrimIO"
	  (* end case *))

    fun blockingOperation (readaNoBlock, block) = 
	     SOME(fn x => 
		  (block(); 
		   case readaNoBlock x 
		     of SOME r => r
		      | NONE => raise Fail "unexpected blocking operation"))


 fun augmentIn (r as Rd r') = let
	fun readaToReadv reada i = let
	      val a = A.array(i, someElem)
              in
		case reada{data=a, first=0, nelems=i}
		 of SOME i' => SOME(A.extract(a, 0, SOME i'))
                  | NONE => NONE  
	      end
	fun readvToReada readv {data: array, first: int, nelems: int} = (
	      case readv nelems
	       of SOME v => let
		    val len = V.length v
		    fun loop i = if i >= len
			  then ()
			  else (
			    A.update(data,i+first,V.sub(v,i));
			    loop(i+1))
		    in
		      loop 0; SOME len
		    end
		| NONE => NONE
	      (* end case *))

	val readBlock' = 
          case r
           of Rd{readBlock=SOME f,...} => SOME f
            | Rd{readaBlock=SOME f,...} => SOME(noOption readaToReadv (SOME o f))
            | Rd{readNoBlock=SOME f,block=SOME b,...} =>
                             SOME(fn i => (b(); noOption (fn x=>x) f i))
            | Rd{readaNoBlock=SOME f, block=SOME b,...} =>
                             SOME(fn x => (b(); noOption readaToReadv f x))
            | _ => NONE

	val readaBlock' = 
          case r
           of Rd{readaBlock=SOME f,...} => SOME f
            | Rd{readBlock=SOME f,...} => SOME(noOption readvToReada (SOME o f))
	    | Rd{readaNoBlock=SOME f, block=SOME b,...} =>
		  blockingOperation(f,b)
	    | Rd{readNoBlock=SOME f,block=SOME b,...} =>
	          blockingOperation(readvToReada f, b)
	    | _ => NONE

	val readNoBlock' =
	   case r
	    of Rd{readNoBlock=SOME f,...} => SOME f
	     | Rd{readaNoBlock=SOME f,...} => SOME(readaToReadv f)
	     | Rd{readBlock=SOME f, canInput=SOME can,...} =>
		   SOME(fn i => if can()
			  then SOME(f i) else NONE)
	     
	     | Rd{readaBlock=SOME f, canInput=SOME can,...} =>
		   SOME(fn i => if can()
			  then readaToReadv (SOME o f) i else NONE)
	     | _ => NONE

	val readaNoBlock' =
	   case r
	    of Rd{readaNoBlock=SOME f,...} => SOME f
	     | Rd{readNoBlock=SOME f,...} => SOME(readvToReada f)
	     | Rd{readaBlock=SOME f, canInput=SOME can,...} =>
		   SOME(fn x => if can()
			  then SOME(f x) else NONE)
	     
	     | Rd{readBlock=SOME f, canInput=SOME can,...} =>
		   SOME(fn x => if can()
			  then readvToReada (SOME o f) x else NONE)
	     | _ => NONE
	     

    in Rd{readBlock=readBlock', readaBlock=readaBlock',
	  readNoBlock=readNoBlock', readaNoBlock=readaNoBlock',
	  block= #block r', canInput = #canInput r',
	  name= #name r', chunkSize= #chunkSize r',
	  close= #close r', getPos = #getPos r', 
	  setPos = #setPos r', endPos = #endPos r', 
	  findPos = #findPos r',
	  desc= #desc r'}
   end

 fun augmentOut (r as Wr r') =
   let fun writevToWritea writev {data,first,nelems} =
             let val v = A.extract(data,first,SOME nelems)
              in writev{data=v,first=0,nelems=nelems}
             end
       fun writeaToWritev writea {data,first,nelems=0} = SOME 0
         | writeaToWritev writea {data,first,nelems} =
             let val a = A.array(nelems,V.sub(data,first))
		 fun loop i = if i >= nelems then  ()
		              else (A.update(a,i,V.sub(data,first+i));
				    loop(i+1))
	      in loop 1; writea{data=a,first=0,nelems=nelems}
             end

       val writeBlock' = 
          case r
           of Wr{writeBlock=SOME f,...} => SOME f
            | Wr{writeaBlock=SOME f,...} => 
		             SOME(noOption writeaToWritev (SOME o f))
            | Wr{writeNoBlock=SOME f,block=SOME b,...} =>
                             SOME(fn i => (b(); noOption (fn x=>x) f i))
            | Wr{writeaNoBlock=SOME f, block=SOME b,...} =>
                             SOME(fn x => (b(); noOption writeaToWritev f x))
            | _ => NONE

       val writeaBlock' = 
          case r
           of Wr{writeaBlock=SOME f,...} => SOME f
            | Wr{writeBlock=SOME f,...} => 
                  SOME(noOption writevToWritea (SOME o f))
	    | Wr{writeaNoBlock=SOME f, block=SOME b,...} =>
		  blockingOperation(f,b)
	    | Wr{writeNoBlock=SOME f,block=SOME b,...} =>
	          blockingOperation(writevToWritea f, b)
	    | _ => NONE

       val writeNoBlock' =
	   case r
	    of Wr{writeNoBlock=SOME f,...} => SOME f
	     | Wr{writeaNoBlock=SOME f,...} => SOME(writeaToWritev f)
	     | Wr{writeBlock=SOME f, canOutput=SOME can,...} =>
		   SOME(fn i => if can()
			  then SOME(f i) else NONE)
	     
	     | Wr{writeaBlock=SOME f, canOutput=SOME can,...} =>
		   SOME(fn i => if can()
			  then writeaToWritev (SOME o f) i else NONE)
	     | _ => NONE

       val writeaNoBlock' =
	   case r
	    of Wr{writeaNoBlock=SOME f,...} => SOME f
	     | Wr{writeNoBlock=SOME f,...} => SOME(writevToWritea f)
	     | Wr{writeaBlock=SOME f, canOutput=SOME can,...} =>
		   SOME(fn x => if can() then SOME(f x) else NONE)
	     
	     | Wr{writeBlock=SOME f, canOutput=SOME can,...} =>
		   SOME(fn x => if can() 
				    then SOME(writevToWritea f x) else NONE)
	     | _ => NONE
	     

    in Wr{writeBlock=writeBlock', writeaBlock=writeaBlock',
	  writeNoBlock=writeNoBlock', writeaNoBlock=writeaNoBlock',
	  block= #block r', canOutput = #canOutput r',
	  name= #name r', chunkSize= #chunkSize r',
	  lineBuf= #lineBuf r',
	  close= #close r', getPos = #getPos r', 
	  setPos = #setPos r', endPos = #endPos r',
	  desc= #desc r'}
   end

end

structure BinPrimIO = PrimIO(structure A = Word8Array
			     structure V = Word8Vector
			     val someElem : Word8.word = 0w0
                             type pos = Position.int
			     val posLess = Position.<)

structure TextPrimIO= PrimIO(structure A = CharArray
			     structure V = CharVector
			     val someElem = #"\000"
			     type pos = Position.int
			     val posLess = Position.<)

