(* imp-io.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

functor ImperativeIO(structure S : STREAM_IO) : IMPERATIVE_IO = 
let abstraction I : sig include IMPERATIVE_IO sharing StreamIO=S end =
 struct
   structure StreamIO = S
   type instream = S.instream ref
   type outstream = S.outstream ref
   type elem = S.elem
   type vector = S.vector
   type subvector = S.subvector
   type pos = S.pos
   val mkInstream = ref
   val getInstream = !
   val setInstream = op :=
   val mkOutstream = ref
   val getOutstream = !
   val setOutstream = op :=
   fun endOf f = if S.endOfStream f then f else endOf(#2(S.input f))

   fun closeIn(r as ref f) = (S.closeIn f; r := endOf f)
   fun setPosIn(r as ref f, i) = r := S.setPosIn(f,i)
   val getPosIn = S.getPosIn o !
   val endPosIn = S.endPosIn o !
   fun inputN (r as ref f, n) = let val (v,f') = S.inputN(f,n) in r:=f'; v end
   fun input (r as ref f) = let val (v,f') = S.input f in r:=f'; v end
   fun input1 (r as ref f) = let val (v,f') = S.input1 f in r:=f'; v end
   fun inputNoBlock (r as ref f) = 
       case S.inputNoBlock f
        of SOME(v,f') => (r := f'; SOME v) 
         | NONE => NONE

   fun inputAll(r as ref f) = let val v = S.inputAll f
                                in r := endOf f; v end
   val endOfStream = S.endOfStream o !
   fun lookahead(ref f) = #1(S.input1 f)

   val closeOut = S.closeOut o !
   fun output(ref f, v) = S.output(f,v)
   fun outputS(ref f, v) = S.outputS(f,v)
   fun output1(ref f, x) = S.output1(f,x)
   val getPosOut = S.getPosOut o !
   fun setPosOut(ref f, i) = S.setPosOut(f,i)
   val endPosOut = S.endPosOut o !
   val flushOut = S.flushOut o !
  end
 in I
end
