(* imp-io-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature IMPERATIVE_IO =
  sig
    type instream 
    type outstream
    type elem
    type vector        
    type subvector
    type pos

    val closeIn      : instream -> unit
    val input        : instream -> vector
    val inputAll     : instream -> vector
    val inputNoBlock : instream -> vector option
    val input1       : instream -> elem option
    val inputN       : instream * int -> vector
    val endOfStream  : instream -> bool
    val lookahead    : instream -> elem option
    val setPosIn     : instream * pos -> unit
    val getPosIn     : instream -> pos
    val endPosIn     : instream -> pos

    val closeOut  : outstream -> unit
    val output    : (outstream * vector) -> unit
    val outputS   : outstream * subvector -> unit
    val output1   : outstream * elem -> unit
    val flushOut  : outstream -> unit
    val getPosOut : outstream -> pos
    val endPosOut : outstream -> pos
    val setPosOut : outstream * pos -> unit

    structure StreamIO : STREAM_IO
      sharing type elem = StreamIO.elem
      sharing type vector = StreamIO.vector
      sharing type subvector = StreamIO.subvector
      sharing type pos = StreamIO.pos

    val mkInstream   : StreamIO.instream -> instream
    val getInstream  : instream -> StreamIO.instream
    val setInstream  : instream * StreamIO.instream -> unit

    val mkOutstream  : StreamIO.outstream -> outstream
    val getOutstream : outstream -> StreamIO.outstream
    val setOutstream : outstream * StreamIO.outstream -> unit

  end

