(* Copyright 1990 by AT&T Bell Laboratories *)
(* stamps.sig *)

signature STAMPS =
sig

  type stamp
  type scope
  type 'a stampMap

  val freeScope  : scope
  val newBoundScope : unit -> scope
  val newStamp : scope -> unit -> stamp
  val setFreeStamp : stamp * string * int  -> unit

  val isFree : stamp -> bool
  val isExternal : stamp -> bool  (* isFree; and setFreeScope has already
				   been called on this scope *)
  val isBound : scope -> stamp -> bool  (* should be called isBoundInScope *)
  val eq : stamp * stamp -> bool
	(* SCStatEnv relies on the fact that eq(null,null)=false *)
  val less : stamp * stamp -> bool
  val greater : stamp * stamp -> bool

  (* for convenience ... *)
  val newFree : unit -> stamp
  val specialFree : string -> stamp

  val error : stamp
  val null : stamp

  val stampToString : stamp -> string
  val hashStamp : (int->unit)*(int->unit)*(string->unit)*
	          (stamp*int->int) * stamp -> unit

  (* stamp maps should be changed to take the scope as an argument also.*)

  val newMap : exn -> '1a stampMap

  (* updateMap - add mapping to a stampMap *)
  val updateMap : '2a stampMap -> stamp * '2a -> unit

  (* applyMap - apply stampMap to a stamp *)
  val applyMap : 'a stampMap * stamp -> 'a

end (* STAMPS *)
