(* Copyright 1994 by AT&T Bell Laboratories *)
(* convertpaths.sml *)


signature CONVERTPATHS =
sig
  val invertSPath : SymPath.path -> InvPath.path
  val invertIPath : InvPath.path -> SymPath.path
end


structure ConvertPaths : CONVERTPATHS =
struct

  (* conversion functions *)

  fun invertSPath(SymPath.SPATH p : SymPath.path) : InvPath.path =
      InvPath.IPATH(rev p)
  fun invertIPath(InvPath.IPATH p : InvPath.path) : SymPath.path =
      SymPath.SPATH(rev p)

end (* ConvertPaths *)
