(* Copyright 1989 by AT&T Bell Laboratories *)
(* access.sig *)

signature ACCESS = sig

  structure P : PRIMOP
  type primop
  eqtype lvar  (* lambda variable id *)
  type slot  (* position in structure record *)
  type path  (* slot chain relative to lambda variable *)

  datatype access 
    = SLOT of slot
    | LVAR of int
    | EXTERN of PersStamps.persstamp
    | INLINE of primop
    | PATH of int * access
    | NO_ACCESS
  
  datatype conrep
      = UNTAGGED
      | TAGGED of int
      | TAGGEDREC of int * int
      | UNTAGGEDREC of int
      | CONSTANT of int
      | TRANSPARENT
      | REF
      | LISTCONS
      | LISTNIL
      | VARIABLE of access (* exception constructor *)
      | VARIABLEc of access (* exception constructor without argument *)

  val mkLvar : unit -> lvar
  val newCanonicalLvars : unit -> unit -> lvar
  val sameName : lvar * lvar -> unit
  val dupLvar : lvar -> lvar
  val namedLvar : Symbol.symbol -> lvar
  val lvarName : lvar -> string
  val lvarIsNamed : lvar -> bool
  val saveLvarNames : bool ref

  val pr_lvar: lvar-> string
  and pr_slot: slot -> string
  and pr_path: path-> string
  and pr_access: access-> string

(* the different kinds of records *)
  datatype record_kind
    = RK_VECTOR
    | RK_RECORD
    | RK_SPILL
    | RK_ESCAPE
    | RK_EXN
    | RK_CONT
    | RK_FCONT
    | RK_KNOWN
    | RK_BLOCK
    | RK_FBLOCK
    | RK_I32BLOCK

end (* signature ACCESS *)
