/* mem-brk.c
 *
 * COPYRIGHT (c) 1993 by AT&T Bell Laboratories.
 *
 *   This provides a low-level memory manager on top of brk(2) for systems
 * that do not implement some form of mmap(/dev/zero).
 */

#include "ml-unixdep.h"
#include "ml-base.h"

struct mem_obj {
    Word_t	*base;	  /* the base address of the object. */
    Word_t	sizeB;	  /* the object's size (in bytes) */
/* was mem_obj_t, not void */
    void	*next;	  /* for linking free headers */
};

PVT mem_obj_t *AllocMemObj();
PVT void FreeMemObj (mem_obj_t *);

#define ALLOC_MEMOBJ()		AllocMemObj()
#define FREE_MEMOBJ(p)		FreeMemObj(p)

#include "mem-common.ins"


PVT mem_obj_t	*FreeList;	/* The free list of memory object descriptors */

/* AllocMemObj:
 * Allocate a memory object descriptor.
 */
PVT mem_obj_t *AllocMemObj()
{
    mem_obj_t	*p;

    if (FreeList == NIL(mem_obj_t *)) {
    }
    else {
	p = FreeList;
	FreeList = p->next;
    }

    return p;

} /* end of AllocMemObj */

/* FreeMemObj:
 * Return a memory object descriptor to the free list.
 */
PVT void FreeMemObj (mem_obj_t *p)
{
    p->next = FreeList;
    FreeList = p;

} /* end of FreeMemObj */

