/* machine-id.h
 *
 * COPYRIGHT (c) 1996 AT&T Research.
 */

#ifndef _MACHINE_ID_
#define _MACHINE_ID_

#ifndef _ML_BASE_
#indlude "ml-base.h"
#endif

#if   defined(TARGET_ALPHA32)
#  define MACHINE_ID	"alpha32"
#elif defined(TARGET_HPPA)
#  define MACHINE_ID	"hppa"
#elif defined(TARGET_M68)
#  define MACHINE_ID	"m68"
#elif (defined(TARGET_MIPS) && defined(BYTE_ORDER_BIG))
#  define MACHINE_ID	"mipseb"
#elif (defined(TARGET_MIPS) && defined(BYTE_ORDER_LITTLE))
#  define MACHINE_ID	"mipsel"
#elif defined(TARGET_RS6000)
#  define MACHINE_ID	"rs6000"
#elif defined(TARGET_SPARC)
#  define MACHINE_ID	"sparc"
#elif defined(TARGET_X86)
#  define MACHINE_ID	"x86"
#elif defined(TARGET_BYTECODE)
#  define MACHINE_ID	"bytecode"
#else
#  error unknown architecture type
#endif

#endif /* _MACHINE_ID_ */

