/* timeofday.c
 *
 * COPYRIGHT (c) 1994 by AT&T Bell Laboratories.
 */

#include "ml-osdep.h"
#include <sys/time.h>
#include "ml-base.h"
#include "ml-values.h"
#include "ml-objects.h"
#include "cfun-proto-list.h"

/* _ml_Time_timeofday : unit -> (int * int)
 *
 * Return the time of day.
 * NOTE: gettimeofday() is not POSIX (time() returns seconds, and is POSIX
 * and ISO C).
 */
ml_val_t _ml_Time_timeofday (ml_state_t *msp, ml_val_t arg)
{
    struct timeval	t;
    ml_val_t		res;

#ifdef HAS_GETTIMEOFDAY
    gettimeofday (&t, NIL(struct timezone *));
    REC_ALLOC2 (msp, res, INT_CtoML(t.tv_sec), INT_CtoML(t.tv_usec));
#else
#error do not know how to get time of day
#endif

    return res;

} /* end of _ml_Time_timeofday */

