/* gettime.c
 *
 * COPYRIGHT (c) 1994 by AT&T Bell Laboratories.
 */

#include "ml-unixdep.h"
#ifdef HAS_TIMEVAL
#include <sys/time.h>
#endif
#include "ml-base.h"
#include "ml-values.h"
#include "ml-objects.h"
#include "vproc-state.h"
#include "ml-state.h"
#include "ml-timer.h"
#include "cfun-proto-list.h"

/* _ml_Time_gettime : unit -> (int * int * int * int * int * int)
 *
 * Return the total CPU time, system time and garbage collection time used by this
 * process so far.
 */
ml_val_t _ml_Time_gettime (ml_state_t *msp, ml_val_t arg)
{
    Time_t		t, s;
    ml_val_t		res;
    vproc_state_t	*vsp = msp->ml_vproc;

    GetCPUTime (&t, &s);

    REC_ALLOC6 (msp, res,
	INT_CtoML(t.seconds), INT_CtoML(t.uSeconds),
	INT_CtoML(s.seconds), INT_CtoML(s.uSeconds),
	INT_CtoML(vsp->vp_gcTime->seconds), INT_CtoML(vsp->vp_gcTime->uSeconds));

    return res;

} /* end of _ml_Time_gettime */

