/* sockets-osdep.h
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * O.S. specific dependencies needed by the sockets library.
 */

#ifndef _SOCKETS_OSDEP_
#define _SOCKETS_OSDEP_

#if defined(OPSYS_UNIX)
#  define HAS_UNIX_DOMAIN
#  define INCLUDE_SOCKET_H	<sys/socket.h>
#  define INCLUDE_IN_H		<netinet/in.h>
#  define INCLUDE_TCP_H		<netinet/tcp.h>
#  define INCLUDE_UN_H		<sys/un.h>

#  if defined(OPSYS_SOLARIS)
#    define INCLUDE_RPCENT_H	<rpc/rpcent.h>

typedef char *sockoptval_t;	/* The pointer type used to pass values to */
				/* getsockopt/setsockopt */

#    define BSD_COMP		/* needed to include FION* in ioctl.h */


#  elif defined(OPSYS_NETBSD)

/* NetBSD defines rpcent in rpc/rpc.h (other systems define it in
   /usr/include/rpc/netdb.h), which also typedefs bool_t.  This bool_t
   conflicts with the one defined in the runtime sources.  Copying
   relevant excerpts of rpc/rpc.h (below) avoids the conflict.  */
struct rpcent {
      char    *r_name;        /* name of server for this rpc program */
      char    **r_aliases;    /* alias list */
      int     r_number;       /* rpc program number */
};

extern struct rpcent *getrpcbyname      (char *);
extern struct rpcent *getrpcbynumber    (int);
extern struct rpcent *getrpcent         (void);
extern void setrpcent (int);
extern void endrpcent (void);

typedef void *sockoptval_t;	/* The pointer type used to pass values to */

#  else
typedef void *sockoptval_t;	/* The pointer type used to pass values to */
				/* getsockopt/setsockopt */
#  endif

#  if (defined(OPSYS_AIX))
#    define _SUN		/* to get the rpcent definitions */
#  endif

/* Some systems have a length field in socket addresses */
#  if (defined(OPSYS_AIX))
#    define SOCKADDR_HAS_LEN
#  endif

#elif defined(OPSYS_WIN32)
#  include <winsock.h>

typedef char *sockoptval_t;	/* The pointer type used to pass values to */
				/* getsockopt/setsockopt */
#endif

#define MAX_SOCK_ADDR_SZB	1024

#endif /* !_SOCKETS_OSDEP_ */

