/* readlink.c
 *
 * COPYRIGHT (c) 1992 by AT&T Bell Laboratories.
 */

#include "ml-unixdep.h"
#include <errno.h>
#include <unistd.h>
#include "ml-base.h"
#include "ml-c.h"
#include "ml-values.h"
#include "ml-state.h"
#include "ml-objects.h"
#include "cfun-proto-list.h"

#define BUF_SZ	2048	/* hope that 2048 > MAX_PATH_LEN for all machines */


/* _ml_OS_readlink : string -> string
 *
 *   Read the contents of the specified symbolic link.
 */
ml_val_t _ml_OS_readlink (ml_state_t *msp, ml_val_t arg)
{
    char	*lname = PTR_MLtoC(char, arg);
#ifdef HAS_SYMLINKS
    int		n;
    char	buf[BUF_SZ];

    n = readlink(lname, buf, BUF_SZ-1);

    if (n >= 0) {
	buf[n] = '\0';
	return ML_CString (msp, buf);
    }
    else if (errno == ENXIO)
	return arg;
    else
	return RAISE_SYSERR (msp, n);

#else /* !HAS_SYMLINKS */
    if (access (lname, 0) == 0)
	return arg;
    else
	return RAISE_SYSERR (msp, -1/* sts*/);
#endif

} /* end of _ml_OS_readlink */

