/* mkdir.c
 *
 * COPYRIGHT (c) 1994 AT&T Bell Laboratories.
 */

#include "ml-unixdep.h"
#include <sys/types.h>
#include <sys/stat.h>
#include "ml-base.h"
#include "ml-values.h"
#include "ml-c.h"
#include "cfun-proto-list.h"

/* _ml_OS_mkdir : string -> unit
 *
 * Create a directory with the given path name and permission bits.
 */
ml_val_t _ml_OS_mkdir (ml_state_t *msp, ml_val_t arg)
{
    char	*path = PTR_MLtoC(char, arg);
    int		mode = S_IRWXU | S_IRWXG | S_IRWXO;
    int		sts;

    sts = mkdir(path, mode);

    CHK_RETURN_UNIT (msp, sts);

} /* end of _ml_OS_mkdir */

