/* getenv.c
 *
 * COPYRIGHT (c) 1995 by AT&T Bell Laboratories.
 */

#include "ml-base.h"
#include "ml-values.h"
#include "ml-objects.h"
#include "cfun-proto-list.h"

/* _ml_OS_getenv : string -> string option
 *
 */
ml_val_t _ml_OS_getenv (ml_state_t *msp, ml_val_t arg)
{
    char	*value;

    value = getenv (PTR_MLtoC(char, arg));

    if (value == NIL(char *))
	return OPTION_NONE;
    else {
	ml_val_t	mlStr = ML_CString(msp, value);
	ml_val_t	res;

	OPTION_SOME(msp, res, mlStr);
	return res;
    }

} /* end of _ml_OS_getenv */

