/* getdir.c
 *
 * COPYRIGHT (c) 1994 AT&T Bell Laboratories.
 */

#include "ml-unixdep.h"
#include <unistd.h>
#include "ml-base.h"
#include "ml-objects.h"
#include "ml-c.h"
#include "cfun-proto-list.h"

/* _ml_OS_getdir:
 */
ml_val_t _ml_OS_getdir (ml_state_t *msp, ml_val_t arg)
{
    char	path[1024];

#if defined(HAS_GETCWD)
    if (getcwd(path, sizeof(path)) == NIL(char *)) {
	return RAISE_ERROR(msp, "unable to handle getdir error");
    }

    return ML_CString (msp, path);
#elif defined(HAS_GETWD)
    getwd (path);

    return ML_CString (msp, path);
#else
    return RAISE_ERROR(msp, "no support for _ml_OS_getdir");
#endif

} /* end of _ml_OS_getdir */
