/* cfun-list.h
 *
 * COPYRIGHT (c) 1994 AT&T Bell Laboratories.
 *
 * This file lists the directory library of C functions that are callable by ML.
 */

#ifndef CLIB_NAME
#define CLIB_NAME	"SMLNJ-OS"
#define CLIB_VERSION	"1.0"
#define CLIB_DATE	"March 21, 1994"
#endif

CFUNC("access",		_ml_OS_access,		"")
CFUNC("modTime",	_ml_OS_modtime,		"string -> int")
CFUNC("setTime",	_ml_OS_settime,		"(string * int option) -> unit")
CFUNC("rename",		_ml_OS_rename,		"(string * string) -> unit")
CFUNC("remove",		_ml_OS_remove,		"string -> unit")
CFUNC("openDir",	_ml_OS_opendir,		"string -> dirstream")
CFUNC("readDir",	_ml_OS_readdir,		"dirstream -> string")
CFUNC("rewindDir",	_ml_OS_rewinddir,	"dirstream -> unit")
CFUNC("closeDir",	_ml_OS_closedir,	"dirstream -> unit")
CFUNC("chDir",		_ml_OS_chdir,		"string -> unit")
CFUNC("getDir",		_ml_OS_getdir,		"unit -> string")
CFUNC("mkDir",		_ml_OS_mkdir,		"string -> unit")
CFUNC("removeDir",	_ml_OS_rmdir,		"string -> unit")
CFUNC("isDir",		_ml_OS_isdir,		"string -> bool")
CFUNC("isLink",		_ml_OS_islink,		"string -> bool")
CFUNC("readLink",	_ml_OS_readlink,	"string -> link")
CFUNC("system",		_ml_OS_system,		"string -> int")
CFUNC("exit",		_ml_OS_exit,		"int -> 'a")
CFUNC("getEnv",		_ml_OS_getenv,		"string -> string option")

