/* access.c
 *
 * COPYRIGHT (c) 1994 by AT&T Bell Laboratories.
 */

#include "ml-unixdep.h"
#include <unistd.h>
#include "ml-base.h"
#include "ml-values.h"
#include "ml-objects.h"
#include "ml-c.h"
#include "cfun-proto-list.h"


/* _ml_OS_access:
 *
 * Check to see if the user has the specified access to the specified file.
 * NOTE: In the long run, there should be a datatype for the return value
 * of access, since it can fail for significantly different reasons
 * (e.g., no such file, not a directory, looping path, ...). -- JHR
 */
ml_val_t _ml_OS_access (ml_state_t *msp, ml_val_t arg)
{
#ifdef HAS_ACCESS
    char	    *path = REC_SELPTR(char, arg, 0);
    ml_val_t	    p = REC_SEL(arg, 1);
    int		    mode = F_OK;

    for (;  p != LIST_nil;  p = LIST_tl(p)) {
        switch (INT_MLtoC(LIST_hd(p))) {
	  case 0: mode |= R_OK; break;
	  case 1: mode |= W_OK; break;
	  case 2: mode |= X_OK; break;
	  default:
	    return RAISE_ERROR (msp, "unknown access mode");
	} /* end of switch */
    } /* end of for */

    if (access(path, mode) == 0)
	return ML_true;
    else
	return ML_false;

#else
  /* We should probably check for file existence */
    return ML_true;
#endif

} /* end of _ml_OS_access */

