/*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni (Edoardo.Biagioni@cs.cmu.edu)
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Ken Cline (Kenneth.Cline@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract

	This file provides an interface to a timing board. The device
 is opened through the frc interface and then mapped into memory. After
 initialize_timingboard is called, timingboard is a pointer to an unsigned
 integer that is the timingboard.
   



		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	iii.	RCS Log
	1.	Includes and Defines
	2.	init_tb
	3.	fin_tb
	4.	fetch_tb
        5.      zero_tb_gc
        6.      strt_tb_gc_minr
        7.      stp_tb_gc_mnr
        8.      strt_tb_gc_mjr
        9.      stp_tb_gc_mjr
       10.      mkstrngs_tb

		iii.	RCS Log
	
$Log$
*/


/*
		1.	Includes and Defines
*/

#define TIMINGBOARD 1
#ifdef TIMINGBOARD 
#include <mach.h>
#include <device/device_types.h>
#include <stdio.h>
#define MIPS 1
#include "ml_types.h" 
#define PrintTimingBoardInitialization 1

unsigned int do_prints = 0;


/*
		2.	init_tb
*/

#ifdef PrintTimingBoardInitialization
char output_buffer[200];
#endif

typedef volatile unsigned int tbregister;
tbregister *timingboard = NULL;
static unsigned int zero = 0;
vm_offset_t timingboard_page = 0;

/* return a value to the calling ML code */
#define RETURN(msp,r)	{		\
    msp->ml_arg = (r);			\
    return;}

void init_tb(void)
{
        kern_return_t   rc;
        mach_port_t     device_server_port, device_port, pager;
        vm_machine_attribute_val_t cacheit;
#ifdef PrintTimingBoardInitialization
	if (do_prints == 1) {
        sprintf(output_buffer,"TimingBoard: starting counter initialization.\n");
        fputs(output_buffer,stdout); };
#endif

        device_server_port = task_by_pid(-2);
        if (device_server_port == MACH_PORT_NULL) {
#ifdef PrintTimingBoardInitialization
	  if (do_prints == 1) {
                sprintf(output_buffer,"TimingBoard: Error getting device port.\n");
                fputs(output_buffer,stdout); };
#endif
	      }
#ifdef PrintTimingBoardInitialization
	if (do_prints == 1) {
        sprintf(output_buffer,"Timingboard: got device port. \n");
        fputs(output_buffer,stdout); };
#endif
	
        rc = device_open(device_server_port, 0, "frc", &device_port);
        if (rc == D_NO_SUCH_DEVICE) {
#ifdef PrintTimingBoardInitialization
	  if (do_prints == 1) {
	        sprintf(output_buffer,"TimingBoard: No frc device, setting timingboard to read an unsigned int zero.\n");
                fputs(output_buffer,stdout); };
#endif
		timingboard = &zero;
                timingboard_page = -1;
                return;
	}
        else if (rc != D_SUCCESS) {
#ifdef PrintTimingBoardInitialization
	  if (do_prints == 1) {
	        sprintf(output_buffer,"TimingBoard: error opening frc device,\n");
                fputs(output_buffer,stdout); };
#endif
		timingboard = &zero;
                return;
        }
        else 
        {

#ifdef PrintTimingBoardInitialization
	  if (do_prints == 1) {
        sprintf(output_buffer,"Timingboard: opened frc device.\n");
        fputs(output_buffer,stdout); };
#endif

        pager = MACH_PORT_NULL;
        rc = device_map(device_port, VM_PROT_READ,
                        0, vm_page_size, &pager, 0);
        if (rc != D_SUCCESS) {
#ifdef PrintTimingBoardInitialization
	  if (do_prints == 1) {
                sprintf(output_buffer,"TimingBoard: error mapping frc device.\n");
                fputs(output_buffer,stdout); };
#endif
		timingboard = &zero;
                return;
	      }
#ifdef PrintTimingBoardInitialization
	  if (do_prints == 1) {
           sprintf(output_buffer,"Timingboard: mapped frc device.\n");
           fputs(output_buffer,stdout); };
#endif
       {
        /* Allocate a page, as otherwise a mach bug lets the vm_map put that
            device anywhere, such as in the middle of mark sweep space. */
        rc = vm_allocate(mach_task_self(), &timingboard_page, vm_page_size,TRUE);
        if (rc |= D_SUCCESS) {      
#ifdef PrintTimingBoardInitialization
	  if (do_prints == 1) {
                sprintf(output_buffer,"TimingBoard: error vm allocating a page for the frc object.\n");
                fputs(output_buffer,stdout); };
#endif
		timingboard = &zero;
                return;
                };
#ifdef PrintTimingBoardInitialization
	if (do_prints == 1) {
          sprintf(output_buffer,"Timingboard: allocated a page for the frc object.\n");
          fputs(output_buffer,stdout); };
#endif
      }
       {
        vm_offset_t counter = timingboard_page;
        rc = vm_map(mach_task_self(),
                    &counter, vm_page_size, 0, FALSE,
                    pager, 0, FALSE,
                    VM_PROT_READ, VM_PROT_READ, VM_INHERIT_NONE);
        if (rc != D_SUCCESS) {
#ifdef PrintTimingBoardInitialization
	  if (do_prints == 1) {
                sprintf(output_buffer,"TimingBoard: error vm mapping frc memory object.\n");
                fputs(output_buffer,stdout); };
#endif
		timingboard = &zero;
                return;
	      }
        
#ifdef PrintTimingBoardInitialization
	if (do_prints == 1) {
          sprintf(output_buffer,"Timingboard: mapped frc memory object.\n");
          fputs(output_buffer,stdout); };
#endif

        rc = mach_port_deallocate(mach_task_self(), pager);
        if (rc != KERN_SUCCESS) {
#ifdef PrintTimingBoardInitialization
	  if (do_prints == 1) {
                sprintf(output_buffer,"TimingBoard: error deallocating frc device port.\n");
                fputs(output_buffer,stdout); };
#endif
		timingboard = &zero;
                return;
	      }
#ifdef PrintTimingBoardInitialization
	if (do_prints == 1) {
        sprintf(output_buffer,"Timingboard: deallocated frc device port.\n");
        fputs(output_buffer,stdout); };
#endif

        /* Now make the frc memory object uncached */
        cacheit = MATTR_VAL_OFF;
        rc = vm_machine_attribute(mach_task_self(), counter, vm_page_size,
                             MATTR_CACHE, &cacheit);
        if (rc != KERN_SUCCESS) {
#ifdef PrintTimingBoardInitialization
	  if (do_prints == 1) {
              sprintf(output_buffer,"Timingboard: error uncaching frc memory object.\n");
              fputs(output_buffer,stdout); };
#endif
		timingboard = &zero;
                return;
	      }
#ifdef PrintTimingBoardInitialization
	if (do_prints == 1) {
           sprintf(output_buffer,"Timingboard: made frc memory object uncached.\n");
           fputs(output_buffer,stdout); };
#endif
	timingboard = (unsigned int *) counter;
      }
#ifdef PrintTimingBoardInitialization
	  if (do_prints == 1) {
            sprintf(output_buffer,"TimingBoard: finished  counter initialization.\n");
            fputs(output_buffer,stdout); };
#endif
      }
}


/*
		3.	fin_tb
*/


void fin_tb(msp,arg)
    MLState_ptr		msp;
    ML_val_t arg;
{
  timingboard = NULL;
  RETURN(msp,INT_CtoML(KERN_SUCCESS));
}

/*
		4.	fetch_tb
*/

void fetch_tb(msp,arg)
    MLState_ptr		msp;
    ML_val_t arg;
{
  /* We know that timingboard is a 4 byte aligned pointer into memory. 
     We shift it right one bit and then do an INT_CtoML which shifts
     it left one bit and adds the tag bit of 1. 
     On the ML side we recover it with a Byte4.from_int * 2.

    If the timingboard is pointing to the zero, then 
    we know it did not initialize and send SML a zero so it
    knows not to bother reading it.
  */

  ML_val_t p;

#ifdef PrintTimingBoardInitialization
  char s[50];
  if (do_prints == 1) {
    sprintf(s, "TimingBoard: timingboard = %x\n", timingboard);
    fputs(s,stdout); };
#endif

  ML_alloc_write(msp, 0, MAKE_DESC(4,TAG_bytearray));
  p = ML_alloc(msp,1);
  *p = (unsigned int) timingboard;
  RETURN(msp,p);

/*  if (timingboard == &zero)
   RETURN(msp,INT_CtoML(((unsigned int) 0) >> 1))
  else
   RETURN(msp,INT_CtoML(((unsigned int) timingboard) >> 1));
*/
}

/*
        5.      zero_tb_gc
*/

unsigned int tb_gc_minor_started_at = 0;
unsigned int tb_gc_minor_total      = 0;
unsigned int tb_gc_major_started_at = 0;
unsigned int tb_gc_major_total      = 0;

void zero_tb_gc(msp,arg)
    MLState_ptr		msp;
    ML_val_t arg;
{
 tb_gc_minor_started_at = 0;
 tb_gc_minor_total      = 0;
 tb_gc_minor_started_at = 0;
 tb_gc_minor_total      = 0;
 RETURN(msp,INT_CtoML(KERN_SUCCESS));
}

/*
        6.      strt_tb_gc_mnr
*/

void strt_tb_gc_mnr(void)
{
  tb_gc_minor_started_at = *timingboard;
}

/*
        7.      stp_tb_gc_mnr
*/
void stp_tb_gc_mnr(void)
{
  unsigned int stop    = *timingboard;

 if (tb_gc_minor_started_at > stop) 
   {
     tb_gc_minor_total = tb_gc_minor_total + (stop - tb_gc_minor_started_at);
     tb_gc_minor_started_at = 0;
   }
 else 
   {
     tb_gc_minor_total = tb_gc_minor_total + stop + (0xFFFFFFFF - tb_gc_minor_started_at);
     tb_gc_minor_started_at = 0;
   }
}

/*
        8.      strt_tb_gc_mjr
*/
void strt_tb_gc_mjr()
{
  tb_gc_major_started_at = *timingboard;
}
/*
        9.      stp_tb_gc_mjr
*/

void stp_tb_gc_mjr()
{
  unsigned int stop    = *timingboard;
 if (tb_gc_major_started_at >= stop) 
   {
     tb_gc_major_total = tb_gc_major_total + (stop - tb_gc_major_started_at);
     tb_gc_major_started_at = 0;
   }
 else 
   {
     tb_gc_major_total = tb_gc_major_total + stop + (0xFFFFFFFF - tb_gc_major_started_at);
     tb_gc_major_started_at = 0;
   }
}
/*
       10.      mkstrngs_tb
*/

void mkstrngs_tb(msp,arg)
    MLState_ptr		msp;
    ML_val_t arg;
{
  char      buf[150];
  ML_val_t s;
  sprintf(buf,"gc_minor               %d\n gc_major               %d",tb_gc_minor_total,tb_gc_major_total);
  s = ML_alloc_string(msp,buf);
  RETURN(msp,s);
  
}

#endif /* TIMINGBOARD */
