/*---------------------------------------------------------------------------*\
 *
 *  ml-ptystuff.c
 *
 *  Definitions of ML-callable C functions:
 *   - openpty
 *   - get_winsize
 *   - set_winsize
 *
\*---------------------------------------------------------------------------*/

#ifdef OPSYS_OSF1

/* Includes -----------------------------------------------------------------*/

#include "ml-osdep.h"
#include "ml-unixdep.h"
#include INCLUDE_FCNTL_H
#include "ml-base.h"
#include "ml-values.h"
#include "ml-state.h"
#include "ml-objects.h"
#include "ml-c.h"
#include "ml-globals.h"

#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/termios.h>
#include <sys/ioctl.h>
#include <sys/poll.h>

/*---------------------------------------------------------------------------*\
 *
 *  poll : int * int -> bool
 *
\*---------------------------------------------------------------------------*/

ml_val_t ml_poll (ml_state_t *msp, ml_val_t arg) {
  struct pollfd pollfd;
  pollfd.fd = REC_SELINT (arg, 0);
  pollfd.events = POLLIN;
  return (poll (&pollfd, 1, REC_SELINT (arg, 1)))? ML_true: ML_false;
}

/*---------------------------------------------------------------------------*\
 *
 *  openpty : int * int -> (int * int)
 *
\*---------------------------------------------------------------------------*/


ml_val_t ml_openpty (ml_state_t *msp, ml_val_t arg) {
  ml_val_t result;

  int master;
  int slave;
  struct winsize win;

  win.ws_row    = REC_SELINT (arg, 0);
  win.ws_col    = REC_SELINT (arg, 1);
  win.ws_xpixel = 0;
  win.ws_ypixel = 0;

  if (openpty (&master, &slave, NULL, NULL, &win) != 0) {
    perror ("ml_openpty: error opening pty");
    return RaiseSysError (msp, NIL(char *));
  }

  REC_ALLOC2 (msp, result, INT_CtoML (master), INT_CtoML (slave));
  return result;
}

/*---------------------------------------------------------------------------*\
 *
 *  setsid: int option -> unit
 *
\*---------------------------------------------------------------------------*/

ml_val_t ml_setsid (ml_state_t *msp, ml_val_t arg) {
  int tty;

  if (setsid() == -1) {
    perror ("ml_setsid: error creating process group");
    return RaiseSysError (msp, NIL(char *));
  }

  tty = INT_MLtoC (arg);
  ioctl (tty, TIOCSCTTY, 0);

  return ML_unit;
}

/*---------------------------------------------------------------------------*\
 *
 *  get_winsize : int -> (int * int)
 *  set_winsize : int * (int * int) -> unit
 *
\*---------------------------------------------------------------------------*/

ml_val_t ml_get_winsize (ml_state_t *msp, ml_val_t arg) {
  ml_val_t result;

  int tty;
  struct winsize win;

  tty = INT_MLtoC (arg);
  ioctl (tty, TIOCGWINSZ, &win);

  REC_ALLOC2
     (msp, result, INT_CtoML (win.ws_row), INT_CtoML (win.ws_col));
  return result;
}
 
ml_val_t ml_set_winsize (ml_state_t *msp, ml_val_t arg) {
  int tty;
  struct winsize win;

  tty = REC_SELINT (arg, 0);
  ioctl (tty, TIOCGWINSZ, &win);
  win.ws_row = REC_SELINT (arg, 1);
  win.ws_col = REC_SELINT (arg, 2);
  ioctl (tty, TIOCSWINSZ, &win);
  
  return ML_unit;
} 

/*---------------------------------------------------------------------------*/

#endif /* OPSYS_OSF1 */
