(* 
 * burg-ast.sml
 *
 * Abstract syntax trees for BURG specifications.
 *)

structure BurgAST =
  struct

    datatype decl_ast = START of string
		      | TERM of (string * string option) list
		      | TERMPREFIX of string
		      | RULEPREFIX of string
		      | SIG of string

    datatype pattern_ast = PAT of (string * pattern_ast list)

    datatype rule_ast = RULE of (string * pattern_ast * string * int list)

    datatype spec_ast = SPEC of {head : string list,
				 decls : decl_ast list, 
				 rules : rule_ast list,
				 tail : string list}
  end (* BurgAST *)

