(*
 * util/getenv.sml: Interface to (OS) environment
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
structure Getenv = struct

    val getenv = Posix.ProcEnv.getenv

    fun getsplitpath c n = let
	fun fieldsep (cc: char) = c = cc
    in
	case getenv n of
	    NONE => NONE
	  | SOME s => SOME (String.fields fieldsep s)
    end

end
