signature ABSPATH = sig

    type t
    eqtype id

    val cur: t
    val dummy: t

    val cwd: unit -> string
    val newcwd: unit -> bool

    val spec: t -> string
    val elab: t -> string
    val id: t -> id
    val sameFile: t * t -> bool

    val native: { context: t, spec: string } -> t
    val standard: { context: t, spec: string } -> t

    val current: string -> t

    val splitDirFile: t -> { dir: t, file: string }
    val joinDirFile: { dir: t, file: string } -> t
    val file: t -> string
    val dir: t -> t

    val splitBaseExt: t -> { base: t, ext: string option }
    val joinBaseExt: { base: t, ext: string option } -> t
    val base: t -> t
    val ext: t -> string option
    val extendExt: { path: t, ext: string, sep: string } -> t

    val exists: t -> bool

    val modTime: t -> Time.time

end
