(*
 * srctypes/source.sig:
 *   Dealing with different types of sources.
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
signature SOURCE = sig

    structure SmlSource: SML_SOURCE

    type t

    exception ToolNotImplemented of string

    (*
     * gen: filename * toolname -> t
     *)
    val gen: AbsPath.t * string -> t
    val name: t -> AbsPath.t

    (*
     * `expanding' a source means running the appropriate tool on it.
     * Running the tool might create Sml files, which can be understood
     * directly, or it might create other files (even description files!)
     * which must be treated differently (e.g. expanded again).
     * The `other' component doesn't consist of `Source.t's, because
     * we also want to be able to create entity description files, which
     * are not considered `sources'.
     *)
    datatype expansion = E of {
			       sml: SmlSource.t list,
			       other: (AbsPath.t * string) list
			              (* (file, tool) *)
			      }

    (*
     * expand: classify -> t -> expansion
     *  `classify' is used to determine the tool when this is unknown.
     *)
    val expand: (string -> string) -> t -> expansion

end
