(*
 * srctypes/rcssource.sml: dealing with RCS archives
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
functor RcsSourceFun (structure Control: CONTROL
		      val processor: string): TOOL_SOURCE =
struct

    exception ToolError of string

    fun runrcsco name = let
	val cmd = concat [processor, " ", AbsPath.elab name]
	val _ = Control.vsay (concat ["[", cmd, "]\n"])
    in
	if (OS.Process.system cmd) = OS.Process.success then ()
	else raise ToolError cmd
    end

    fun update path = let
	val { dir, file } = AbsPath.splitDirFile path
	val workfile = substring (file, 0, size file - 2) (* strip ,v *)
	fun isCur d = d = "" orelse d = OS.Path.currentArc
	val workdir =
	    if isCur (AbsPath.elab dir) then dir
	    else let
		val { dir = parentdir, file = subdir } =
		    AbsPath.splitDirFile dir
	    in
		if subdir = "RCS" then parentdir else dir
	    end
	val workpath = AbsPath.joinDirFile { dir = workdir, file = workfile }
    in
	(if AbsPath.exists workpath then ()
	 else runrcsco workpath);
	([], [(workpath, NONE)])
    end
end
