(*
 * srctypes/lexsource.sml: dealing with ml-lex input
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
functor LexSourceFun (structure Control: CONTROL
		      val processor: string): TOOL_SOURCE =
struct

    exception ToolError of string

    fun runlex name = let
	val cmd = concat [processor, " ", AbsPath.elab name]
	val _ = Control.vsay ("[" ^ cmd ^ "]\n")
    in
	if (OS.Process.system cmd) = OS.Process.success then ()
	else raise ToolError cmd
    end

    fun update name = let
	val smlfile = AbsPath.extendExt { path = name, ext = "sml", sep = "." }
	val sourcetime = AbsPath.modTime name
    in
	(if  AbsPath.exists smlfile andalso
	     Time.< (sourcetime, AbsPath.modTime smlfile)
	 then ()
	 else runlex name);
	([smlfile], [])
    end

end
