(*
 * srctypes/fname-rules.sml:
 *   Rules for how to make up names for CM-managed
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
signature FNAME_RULES = sig

    type textfile = { open_in: unit -> TextIO.instream,
		      open_out: unit -> TextIO.outstream,
		      name: AbsPath.t }

    type binfile = { open_in: unit -> BinIO.instream,
		     open_out: unit -> BinIO.outstream,
		     name: AbsPath.t }

    val declFileFor: AbsPath.t -> textfile
    val binFileFor: AbsPath.t -> binfile
    val stableFileFor: AbsPath.t -> textfile

    val errorTextFile: exn -> textfile
end
