(*
 * sched/lists.sml: Make various topologically sorted name lists
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
functor ListsFun (LinearSched: LINEAR_SCHED): LISTS = struct

    structure SysDag = LinearSched.SysDag
    structure GroupDag = SysDag.GroupDag
    structure SmlSource = GroupDag.SmlSource

    fun d2sml (GroupDag.DAG { smlsource, ... }) = smlsource

    fun sml2name sml = AbsPath.elab (SmlSource.name sml)
    fun sml2binfile sml = AbsPath.elab (#name (SmlSource.binfile sml))
    fun sml2string sml = SmlSource.makestring sml

    val d2name = sml2name o d2sml
    val d2binfile = sml2binfile o d2sml
    val d2string = sml2string o d2sml

    val smls = LinearSched.linearize d2sml
    val names = LinearSched.linearize d2name
    val binfiles = LinearSched.linearize d2binfile
    val strings = LinearSched.linearize d2string

end
