(*
 * driver/driver.sml:
 *   Invoking the dependency analysis and drive some other actions
 *   using the resulting dependency graph
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
functor DriverFun (structure SysDag: SYS_DAG
		   structure Control: CONTROL
		   structure SysEnv: SYS_ENV
		   val path: string list
		   val symval: string -> int option
		   sharing
		       SysDag.GroupDag.SmlSource.Compiler =
		       SysEnv.Compiler): DRIVER = 

struct

    structure SysDag = SysDag
    structure EntityDesc = SysDag.EntityDesc
    structure Compiler = SysDag.GroupDag.SmlSource.Compiler

    type senv = Compiler.Environment.staticEnv

    val path = ref (map AbsPath.current path)

    fun driver (action, staticBaseEnv) groupfile = let
	fun symdef s =
	    case Compiler.Environment.cmEnvOfModule staticBaseEnv s of
		Compiler.Environment.CM_NONE => false
	      | _ => true
	val strdef = symdef o Compiler.Symbol.strSymbol
	val sigdef = symdef o Compiler.Symbol.sigSymbol
	val fctdef = symdef o Compiler.Symbol.fctSymbol
	val fsigdef = symdef o Compiler.Symbol.fsigSymbol
	val ep = EntityDesc.EP {
				path = !path,
				classify = Classify.classify,
				lparm = {
					 strdef = strdef,
					 sigdef = sigdef,
					 fctdef = fctdef,
					 fsigdef = fsigdef,
					 symval = symval
					}
			       }
	val _ = AbsPath.newcwd ()
	val _ = Control.vsay "[starting dependency analysis]\n"
	val ae = SysDag.analyze (ep, groupfile, staticBaseEnv)
	val _ = Control.vsay "[dependency analysis completed]\n"
    in
	action ae
    end

    fun sysenv'driver action groupfile =
	driver (action, SysEnv.getStaticBaseEnv ()) groupfile

end
