(*
 * driver/classify.sml: classify files according to file name extensions
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
structure Classify = struct

    exception UnknownExtension of string

    fun classify filename =
	case OS.Path.ext filename of
	    SOME "grm" => "mlyacc"
	  | SOME "y" => "mlyacc"
	  | SOME "lex" => "mllex"
	  | SOME "l" => "mllex"
	  | SOME "burg" => "mlburg"
	  | SOME "sc" => "scgroup"
	  | SOME "cm" => "cmfile"
	  | SOME "a" => "archive"
	  | SOME "sml" => "sml"
	  | SOME "sig" => "sml"
	  | SOME "fun" => "sml"
	  | SOME "link" => "sml"
	  | SOME "yacc" => "sml"
	  | _ =>
		if size filename > 2 andalso
		    substring (filename, size filename - 2, 2) = ",v" then
		    "rcs"
		else
		    raise UnknownExtension filename

end
