(*
 * driver/autoload.sig: CM autoloader
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
signature AUTO_LOAD = sig

    structure Compiler: COMPILER
    structure SD: SYS_DAG

    type environ = Compiler.BareEnvironment.environment
    type envRef = { get: unit -> environ, set: environ -> unit }

    val register: SD.analyzed_entity -> unit
    val manager: Compiler.Ast.dec * envRef * envRef -> unit
    val clear: unit -> unit

end
