(*
 * decl/decl.sig: create and cache `MD.decl's
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
signature DECL = sig

    structure MD: MODDECL
    structure Compiler: COMPILER

    exception FormatError and InternalError

    (*
     * recover: `open_in declfile' * declfile * sourcetime option
     *  -> MD.decl option
     *   - recover a decl data structure from the declfile specified
     *     (if possible) unless the source is newer.
     *   - if everything is ok then return SOME decl, otherwise NONE.
     *)
    val recover:
	(unit -> TextIO.instream) * AbsPath.t * Time.time option 
	->
	MD.decl option

    (*
     * create: ast * `open_out declfile' * declfile -> MD.decl
     *  - create a decl data structure from an abstract syntax tree
     *  - cache the result in declfile
     *)
    val create:
	Compiler.Ast.dec * (unit -> TextIO.outstream) * AbsPath.t
	* Compiler.Source.inputSource
	-> MD.decl

    datatype member =
	ENTITY of { name: AbsPath.t, class: string }
      | FILE of { name: AbsPath.t, decl: MD.decl }

    (*
     * recover_stable: `open_in stablef' * stablef * cmf time * context
     *   -> member list option
     *  read a list of sourcename * MD.decl pairs from stablefile (if this
     *  isn't older than the corresponding CM-file).
     *  Return SOME (member list) or NONE.
     *)
    val recover_stable:
	(unit -> TextIO.instream) * AbsPath.t * Time.time * AbsPath.t
	-> member list option

    (*
     * create_stable:
     *  (filename * decl) list * `open_out stablefile' * stablefile
     *  -> unit
     *  Create stablefile.
     *)
    val create_stable:
	member list * (unit -> TextIO.outstream) * AbsPath.t -> unit

end
