(*
 * compile/lazyenv.sml:
 *   Lazy generic environment layering and consolidation
 *    - this is a performance hack
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
functor LazyEnvFun (val threshold: int): LAZY_ENV = struct

    datatype 'a recipe =
	PLAIN of 'a
      | LAYER of 'a t * 'a t
      | CONSOLIDATE of 'a recipe
      | COERCE of ('a -> 'a) * 'a t

    and 'a t =
	E of { e: 'a recipe ref, n: int ref }

    fun make e = E { e = ref (PLAIN e), n = ref 1 }

    fun normalize (env as E { e, n }) =
	if !n < threshold then env
	else let
	    val ne = CONSOLIDATE (!e)
	in
	    e := ne; n := 1; env
	end

    fun layer (e1, e2) = let
	val e1 as E { n = ref n1, ... } = normalize e1
	val E { n = ref n2, ... } = e2
    in
	E { e = ref (LAYER (e1, e2)), n = ref (n1 + n2) }
    end

    fun coerce f e = let
	val e as E { n = ref n, ... } = normalize e
    in
	E { e = ref (COERCE (f, e)), n = ref (n + 1) }
    end

    fun gen (layer, consolidate) = let

	fun get le = let
	    fun eval_r (PLAIN e) = e
	      | eval_r (LAYER (e1, e2)) = layer (eval_t e1, eval_t e2)
	      | eval_r (CONSOLIDATE r) = consolidate (eval_r r)
	      | eval_r (COERCE (f, e)) = f (eval_t e)
	    and eval_t (E { e, ... }) = let
		val ne = eval_r (!e)
	    in
		e := PLAIN ne; ne
	    end
	in
	    eval_t le
	end

    in
	get
    end

end
