(*
 * compile/lazyenv.sig:
 *   Lazy generic environment layering and consolidation
 *    - this is a performance hack
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
signature LAZY_ENV = sig

    type 'a t				(* opaque lazy environment *)

    (*
     * Given a `layer' function and a `consolidate' function for
     * ordinary environments construct and return the `get'
     * primitive for the corresponding lazy environments as follows:
     *
     *  get: lazy env -> env
     *   Fetch the underlying ordinary environment from a lazy one.
     *   This is the only potentially expensive operation.  The amount
     *   of work, however, is likely to be amortized over many `get'
     *   operations if there is a lot of sharing among environments.
     *)
    val gen:
	('a * 'a -> 'a) *		 (* ordinary layer *)
	('a -> 'a)			 (* ordinary consolidate *)
	->
	('a t -> 'a)			 (* get *)

    (*
     * Surprisingly, none of the other operations need to be
     * specialized by ordinary layering or consolidation functions...
     *)

    (*
     * make: env -> lazy env
     *  Construct lazy kind of environment from ordinary kind.
     *)
    val make: '1a -> '1a t

    (*
     * layer: lazy env * lazy env -> lazy env
     *  Layer lazy environments.
     *)
    val layer: '1a t * '1a t -> '1a t

    (* coerce: (env -> env) -> (lazy env -> lazy env)
     *  Given a pure function mapping ordinary environments to
     *  ordinary environments produce an analogous mapping
     *  between corresponding lazy environments.  Note, however,
     *  that the call to the ordinary function will be delayed
     *  until a call to `get' (see above) occurs, which touches this
     *  portion of the environment.  This means that the call
     *  might even be delayed indefinitely.
     *)
    val coerce: ('1a -> '1a) -> ('1a t -> '1a t)

end
