(*
 * iii.sml -- Implementation if `Import Identifiers'
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
functor IIDFun (structure Compiler: COMPILER): IID = struct

    structure Compiler = Compiler
    structure Bare = Compiler.BareEnvironment
    structure Env = Compiler.Environment
    structure Pid = Compiler.PersStamps
    structure Comp = Compiler.Compile
    type senv = Compiler.Environment.staticEnv
    type pid = Pid.persstamp

    type t = { senv: pid, lambda: pid }
    type set = t Set.set

    fun pid_eq (x, y) = (Pid.stampToString x) = (Pid.stampToString y)
    val pid_lt = Pid.less

    fun eq (i1: t, i2: t) =
	pid_eq (#senv i1, #senv i2) andalso
	pid_eq (#lambda i1, #lambda i2)
    fun lt (i1: t, i2: t) =
	pid_lt (#senv i1, #senv i2) orelse
	    pid_eq (#senv i1, #senv i2) andalso
	    pid_lt (#lambda i1, #lambda i2)

    fun new x = x

    fun e2b e = Bare.staticPart
	(Compiler.CoerceEnv.e2b
	 (Env.mkenv { 
		     static = e,
		     dynamic = Env.dynamicPart Env.emptyEnv,
		     symbolic = Env.symbolicPart Env.emptyEnv
		    }))

    fun aug ({ senv, lambda }, senv') =
	{ senv = Comp.makePid (e2b senv'), lambda = lambda }

    val len = 16
    val size = len + len

    fun extern { senv, lambda } =
	(Pid.stampToString senv) ^ (Pid.stampToString lambda)

    fun intern s = let
	val s1 = substring (s, 0, 16)
	val s2 = substring (s, 16, 16)
    in
	{ senv = Pid.stringToStamp s1, lambda = Pid.stringToStamp s2 }
    end

    val { union, makeset, isSubset, ... } = Set.gen { eq = eq, lt = lt }

end
