(*
 * analysis/imp-exp.sig:
 *   Compute the imports and exports for one SML source file.
 *
 *   Copyright (c) 1995 by AT&T Bell Laboratories
 *
 * author: Matthias Blume (blume@cs.princeton.edu)
 *)
signature IMP_EXP = sig

    structure ModuleName: MODULE_NAME
    structure MD: MODDECL
    structure Compiler: COMPILER
    sharing ModuleName = MD.ModuleName
    sharing Compiler = ModuleName.Compiler

    (* env is an opaque type carrying information about symbols *)
    type env

    val mkBaseLookup:
	Compiler.Environment.staticEnv
	->
	ModuleName.t -> env

    val imports:
	MD.decl *
	'info *				(* null info *)
	(ModuleName.t -> env * 'info) *	(* get env and info for global sym. *)
	('info * 'info -> 'info) *	(* combine information *)
	string
	->
	(ModuleName.t -> env) * 'info

    val exports: MD.decl -> ModuleName.set

    exception Undefined of ModuleName.t
    and IllegalToplevelOpen
    and InternalError of string

end
