(* mono-array-sig.sml
 *
 * COPYRIGHT (c) 1993 by AT&T Bell Laboratories.  See COPYRIGHT file for details.
 *
 * Signature for core of monomorphic arrays (used as functor argument).
 *
 *)

signature MONO_ARRAY =
  sig

    type array
    type elem

    exception Subscript
    exception Size

    val length : array -> int
    val array  : (int * elem) -> array
    val sub    : (array * int) -> elem
    val update : (array * int * elem) -> unit

  end; (* MONO_ARRAY *)

