(* stringtoint.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * NOTE: eventually, this all should be done using bignums and a parameterization
 * of the numeric types.
 *)

signature STRING_TO_NUM =
  sig
    val int    : string -> int
    val word   : string -> word
    val word8  : string -> word
    val word32 : string -> Word32.word
  end

structure StringToNum : STRING_TO_NUM =
  struct

    fun scanCharList scanFn cl = (case (StringCvt.scanList scanFn cl)
	   of (SOME x) => x
	    | NONE => raise Option
	  (* end case *))

    fun scanIntLit scanFn s = (case (explode s)
	   of (#"~" :: #"0" :: #"x" :: rest) =>
		scanCharList (scanFn StringCvt.HEX) (#"~" :: rest)
	    | (#"0" :: #"x" :: rest) =>
		scanCharList (scanFn StringCvt.HEX) rest
	    | rest => scanCharList (scanFn StringCvt.DEC) rest
	  (* end case *))

    fun scanWordLit scanFn s = (case (explode s)
	   of (#"0" :: #"w" :: #"x" :: rest) =>
		scanCharList (scanFn StringCvt.HEX) rest
	    | (#"0" :: #"w" :: rest) =>
		scanCharList (scanFn StringCvt.DEC) rest
	    | rest =>
		scanCharList (scanFn StringCvt.DEC) rest
	  (* end case *))

    val int    = scanIntLit Int.scan
    val word   = scanWordLit Word.scan
    fun word8 s = let val w = word s
	  in
	    if (Word.<(0wxFF, w)) then raise Overflow else w
	  end
    val word32 = scanWordLit Word32.scan

  end

