(* Copyright 1994 by AT&T Bell Laboratories *)
(* util/listutil.sml *)

(* This module contains a couple useful list functions that should
   be in List, and are also implemented in the smlnj-lib List structure.
   So ListUtil should be eliminated at some time.
*)

signature LIST_UTIL =
sig
  exception Prefix
  exception Last

  val prefix : int * 'a list -> 'a list

  val last : 'a list -> 'a

end (* LISTUTIL *)


structure ListUtil: LIST_UTIL =
struct

exception Prefix

fun prefix(0,l) = nil
  | prefix(n,h::t) = h::prefix(n-1,t)
  | prefix(n,nil) = raise Prefix

exception Last

fun last [x] = x
  | last (_ :: t) = last t
  | last nil = raise Last

end (* ListUtil *)
