(* reconstruct.sml
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

structure Reconstruct : sig val expType : Absyn.exp -> Types.ty end =
struct

  open Access Absyn ElabUtil Variables Types BasicTypes TypesUtil

   fun bad s = ErrorMsg.impossible (s ^ " in Reconstruct")

infix -->

fun reduceType(POLYty{tyfun=TYFUN{body,arity},...}) = headReduceType body
  | reduceType ty = headReduceType ty

fun poly1 ty = POLYty{sign=[{weakness=infinity,eq=false}],abs=0,
				  tyfun=TYFUN{arity=1,body=ty}}

  val sortFields = Sort.sort (fn ((LABEL{number=n1,...},_),
				  (LABEL{number=n2,...},_)) => n1>n2)
   fun expType(VARexp(_,SOME ty)) = ty
     | expType(VARexp(ref(VALvar{typ=ref ty,...}),_)) = ty
     | expType(VARexp _) = bad "varexp"
     | expType(CONexp(_,SOME ty)) = ty
     | expType(CONexp(DATACON{typ,...},_)) = typ
     | expType(INTexp _) = intTy
     | expType(WORDexp _) = wordTy
     | expType(STRINGexp _) = stringTy
     | expType(CHARexp _) = charTy
     | expType(REALexp _) = realTy
     | expType(RECORDexp fields) =
           let fun extract(LABEL{name,...},exp) = (name,expType exp)
            in recordTy(map extract (sortFields fields))
           end
     | expType(VECTORexp(nil,vty)) = CONty(vectorTycon,[vty])
                                    (* poly1(CONty(vectorTycon,[IBOUND 0])) *)
     | expType(VECTORexp((a::_),vty)) = CONty(vectorTycon,[vty])
                                    (* CONty(vectorTycon,[expType a]) *)
     | expType(SEQexp [a]) = expType a
     | expType(SEQexp (_::rest)) = expType(SEQexp rest)
     | expType(APPexp(rator,rand)) =
           (case reduceType(expType rator)
             of CONty(_,[_,t]) => t
              | POLYty _ => bad "poly-rator"
              | WILDCARDty => bad "wildcard-rator"
              | UNDEFty => bad "undef-rator"
              | IBOUND _ => bad "ibound-rator" 
              | VARty _ => bad "varty-rator"
              | _ => bad "rator")
     | expType(CONSTRAINTexp(e,ty)) = expType e
     | expType(HANDLEexp(e,h)) = expType e
     | expType(RAISEexp(e,t)) = t
     | expType(LETexp(_,e)) = expType e
     | expType(CASEexp(_,RULE(_,e)::_)) = expType e
     | expType(FNexp(RULE(_,e)::_, ty)) = ty --> expType e
     | expType(MARKexp(e,_)) = expType e
     | expType _ = bad "expType"
   
end
